cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

global type tavg

use "crn_pairs $type 150.dta", clear

kdensity coef, generate(crn_est crn_density) nograph

keep crn_est crn_density
drop if crn_est == .
tempfile data
save "`data'", replace

cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"
global type tavg

use "pair_trend_results $type 150.dta", clear

kdensity coef if adjustments == "raw", generate(raw_est raw_density) nograph
kdensity coef if adjustments == "adj", generate(adj_est adj_density) nograph

keep raw_density- adj_est
drop if raw_density == .
append using "`data'"

replace raw_est = . if raw_est > 0.3

#delimit ;
twoway 
	(area crn_density crn_est, color(green) lwidth(none) lpattern(dot) fintensity(inten10))
	(line raw_density raw_est, lcolor(blue) lwidth(medthin))
	(line adj_density adj_est, lcolor(red) lwidth(medthin))
    ,
    ytitle("Probability Density", size(medsmall))
    xtitle("Trend Difference (Degrees C)", size(medsmall))
  	xlabel(-0.3(0.1)0.3,labsize(medium))
  	ylabel(0(5)20, gmax glcolor(black) glpattern(dot) labsize(medium)) 
  	graphregion(color(white) lcolor(ebg))
	legend(region(fcolor(white) lcolor(white)) size(medsmall) position(6) label(1 "USCRN-only Pairs") label(2 "USHCN Raw")  label(3 "USHCN Adjusted") order(2 3 1) col(3))
    plotregion( m(b=0) )
	;
#delimit cr

graph export "CRN HCN Trend Diff Density with Reference $type.png", replace width(1000)
